/*
 * ezlcd.h
 * by Mauro Grassi May 2007
 * Driver for ezLCD LCD module
 *
 * Connected by serial interface through DEBUG port of AT91SAM7X256C 
*/

#ifndef EZLCD_H
#define EZLCD_H

#include "types.h"
#include "common.h"

#define EZLCD_DELAY 100
#define LCDTRIS		(TRISBbits.TRISB5)
#define LCDPOWER	(LATBbits.LATB5)

extern void writec_ezlcd(BYTE);
extern void disa(int, int, int);
extern void iitoa(int, BYTE*, int);
extern void disdec(int, int, int);
extern void disdecfree(int);
extern void init_ezlcd(void);
extern void sendc_ezlcd(BYTE);
extern void writestring_ezlcd(BYTE*);
extern void setcolour_ezlcd(int);
extern void setfont_ezlcd(int);
extern void setbgcolour_ezlcd(int);
extern void disafree(int);
extern void setcursor_ezlcd(int, int);
extern void disword(int);
extern void disdword(long);
extern void cls_ezlcd(void);
extern void sendc_dbguart(BYTE);
extern void light_ezlcd(BYTE);

#endif
